import { UserService } from './user.service';
import { CreateUserDto } from './dto/create-user.dto';
import { UpdateUserDto } from './dto/update-user.dto';
import { Request } from 'express';
export declare class UserController {
    private readonly userService;
    constructor(userService: UserService);
    getAdminData(): {
        message: string;
    };
    getPegawaiData(): {
        message: string;
    };
    getProfile(req: Request): Promise<import("../entities/user.entity").User>;
    updateProfile(req: Request, dto: UpdateUserDto): Promise<import("../entities/user.entity").User>;
    create(dto: CreateUserDto): Promise<import("../entities/user.entity").User>;
    findAll(): Promise<import("../entities/user.entity").User[]>;
    findOne(id: number): Promise<import("../entities/user.entity").User>;
    update(id: number, dto: UpdateUserDto): Promise<import("../entities/user.entity").User>;
    softDelete(id: number): Promise<import("../entities/user.entity").User>;
    deleteByUsername(body: {
        username: string;
    }): Promise<import("../entities/user.entity").User | {
        message: string;
    }>;
    uploadFotoProfile(req: Request, file: Express.Multer.File): Promise<import("../entities/user.entity").User>;
}
