"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const bcrypt = __importStar(require("bcryptjs"));
const dotenv = __importStar(require("dotenv"));
const user_entity_1 = require("./entities/user.entity");
const barang_entity_1 = require("./entities/barang.entity");
const ormconfig_1 = __importDefault(require("../ormconfig"));
dotenv.config();
async function seed() {
    const dataSource = await ormconfig_1.default.initialize();
    await truncateUserTable(dataSource);
    await truncateBarangTable(dataSource);
    await seedUsers(dataSource);
    await seedBarang(dataSource);
    await dataSource.destroy();
    console.log('Seeding user dan barang selesai');
}
async function truncateUserTable(dataSource) {
    await dataSource.query(`
    TRUNCATE TABLE "users" RESTART IDENTITY CASCADE
  `);
}
async function truncateBarangTable(dataSource) {
    await dataSource.query(`
    TRUNCATE TABLE "barang" RESTART IDENTITY CASCADE
  `);
}
async function seedUsers(dataSource) {
    const userRepo = dataSource.getRepository(user_entity_1.User);
    const users = [
        {
            nama: 'Admin SIAP',
            username: 'admin',
            password: await bcrypt.hash('admin123', 10),
            role: 'admin',
            unit_kerja: 'Sistem Administrator',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Admin+SIAP',
        },
        {
            nama: 'Eko Purnomo, SST., MM',
            username: 'eko.purnomo',
            password: await bcrypt.hash('197309131994031004', 10),
            role: 'admin',
            unit_kerja: 'Kepala BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Eko+Purnomo',
        },
        {
            nama: 'Erwansyah Yusup',
            username: 'erwansyah',
            password: await bcrypt.hash('197205201994031004', 10),
            role: 'pegawai',
            unit_kerja: 'Fungsional Umum BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Erwansyah+Yusup',
        },
        {
            nama: 'Tri Budi Setiawan',
            username: 'tri.bs',
            password: await bcrypt.hash('197509032006041020', 10),
            role: 'pegawai',
            unit_kerja: 'Fungsional Umum BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Tri+Budi+Setiawan',
        },
        {
            nama: 'Fazani',
            username: 'fazani',
            password: await bcrypt.hash('198405212007011001', 10),
            role: 'pegawai',
            unit_kerja: 'Fungsional Umum BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Fazani',
        },
        {
            nama: 'Agistin Nafta',
            username: 'agustin.nafta',
            password: await bcrypt.hash('197008032007012004', 10),
            role: 'pegawai',
            unit_kerja: 'Fungsional Umum BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Agistin+Nafta',
        },
        {
            nama: 'Saifu Rohmatullah',
            username: 'saifu.rohmatullah',
            password: await bcrypt.hash('198002022009011010', 10),
            role: 'pegawai',
            unit_kerja: 'Fungsional Umum BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Saifu+Rohmatullah',
        },
        {
            nama: 'Resty Sopiyono, SST, M.E.K.K.',
            username: 'sresty',
            password: await bcrypt.hash('198810132010122005', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Madya BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Resty+Sopiyono',
        },
        {
            nama: 'Syamsul Bahri, S.Si',
            username: 'bahri.syamsul',
            password: await bcrypt.hash('197205231995121001', 10),
            role: 'pegawai',
            unit_kerja: 'Pranata Komputer Ahli Muda BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Syamsul+Bahri',
        },
        {
            nama: 'Andi Stiawan, SP',
            username: 'andi.stiawan',
            password: await bcrypt.hash('197007112003121003', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Muda BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Andi+Stiawan',
        },
        {
            nama: 'Dewi Yuliana S., S.T.',
            username: 'dewiyuliana',
            password: await bcrypt.hash('198207182005022001', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Muda BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Dewi+Yuliana',
        },
        {
            nama: 'Fithriyah, SST',
            username: 'fitriyah',
            password: await bcrypt.hash('198506202007012005', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Muda BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Fithriyah',
        },
        {
            nama: 'Arum Pratiwi, SST',
            username: 'arump',
            password: await bcrypt.hash('198309022009022008', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Muda BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Arum+Pratiwi',
        },
        {
            nama: 'Nisalasi Ikhsan Nurfathillah, SST',
            username: 'nisalasi',
            password: await bcrypt.hash('198702162009022009', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Muda BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Nisalasi+Ikhsan+Nurfathillah',
        },
        {
            nama: 'Ahmad Rifki Febrianto, SST, M.EKK',
            username: 'arifki',
            password: await bcrypt.hash('198902082010121005', 10),
            role: 'pegawai',
            unit_kerja: 'Pranata Komputer Ahli Muda BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Ahmad+Rifki+Febrianto',
        },
        {
            nama: 'Muhamad Zaenuri, S.P.',
            username: 'muh.zaenuri',
            password: await bcrypt.hash('198005262011011005', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Muda BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Muhamad+Zaenuri',
        },
        {
            nama: 'Dinny Pravitasari, SST, M.S.E.',
            username: 'dinnypravita',
            password: await bcrypt.hash('198908092013112001', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Pertama BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Dinny+Pravitasari',
        },
        {
            nama: 'Surachman Budiarto, S.Si',
            username: 'budi.surachman',
            password: await bcrypt.hash('198410012011011013', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Pertama BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Surachman+Budiarto',
        },
        {
            nama: 'Fanisa Dwita Hanggarani, SST',
            username: 'fanisa',
            password: await bcrypt.hash('199405092016022001', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Muda BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Fanisa+Dwita+Hanggarani',
        },
        {
            nama: 'Annisa Fauziatul Mardiyah, SST',
            username: 'annisa.mardiyah',
            password: await bcrypt.hash('199404202017012001', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Pertama BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Annisa+Fauziatul+Mardiyah',
        },
        {
            nama: 'Sela Anisada, S.Tr.Stat.',
            username: 'sela.anisada',
            password: await bcrypt.hash('199707132019122001', 10),
            role: 'pegawai',
            unit_kerja: 'Pranata Komputer Ahli Pertama BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Sela+Anisada',
        },
        {
            nama: 'Esa Anindika Sari, S.Tr.Stat.',
            username: 'esa.anindika',
            password: await bcrypt.hash('199910302022012002', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Pertama BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Esa+Anindika+Sari',
        },
        {
            nama: 'Miftahul Husna, S.Tr.Stat.',
            username: 'miftahul.husna',
            password: await bcrypt.hash('199911292022012002', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Pertama BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Miftahul+Husna',
        },
        {
            nama: 'Ahmad Rifjayansyah, S.Tr.Stat.',
            username: 'ahmadrifjayansyah',
            password: await bcrypt.hash('200006222023021004', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Ahli Pertama BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Ahmad+Rifjayansyah',
        },
        {
            nama: 'Riki Afrianto, A.Md.',
            username: 'rikiafrianto-pppk',
            password: await bcrypt.hash('199304242024211005', 10),
            role: 'pegawai',
            unit_kerja: 'Pranata Komputer Terampil BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Riki+Afrianto',
        },
        {
            nama: 'Ayu Setianingsih, A.Md.Stat.',
            username: 'ayusetianingsih',
            password: await bcrypt.hash('200002092023022003', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Terampil BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Ayu+Setianingsih',
        },
        {
            nama: 'Dini Alfitri Zahra, A.Md.Stat.',
            username: 'dinialfitrizahra',
            password: await bcrypt.hash('200001262023022001', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Terampil BPS Kabupaten/Kota',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Dini+Alfitri+Zahra',
        },
        {
            nama: 'Singgih Adiwijaya, S.E., M.M.',
            username: 'singgih.adiwijaya',
            password: await bcrypt.hash('198605302009111001', 10),
            role: 'pegawai',
            unit_kerja: 'Analis Pengelolaan Keuangan APBN Ahli Muda Subbagian Umum',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Singgih+Adiwijaya',
        },
        {
            nama: 'Diah Hadianing Putri, S.Si',
            username: 'diah.hp',
            password: await bcrypt.hash('198512212012122002', 10),
            role: 'pegawai',
            unit_kerja: 'Statistisi Penyelia Subbagian Umum',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Diah+Hadianing+Putri',
        },
        {
            nama: 'Fitri Nurjanah, S.E., M.M.',
            username: 'fitri.nurjanah',
            password: await bcrypt.hash('198905052011012013', 10),
            role: 'pegawai',
            unit_kerja: 'Pranata Keuangan APBN Mahir Subbagian Umum',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Fitri+Nurjanah',
        },
        {
            nama: 'Eklesia Valentia, A.Md.Kb.N.',
            username: 'eklesia.valentia',
            password: await bcrypt.hash('199902142022012004', 10),
            role: 'pegawai',
            unit_kerja: 'Pranata Keuangan APBN Terampil Subbagian Umum',
            status_aktif: true,
            foto: 'https://ui-avatars.com/api/?name=Eklesia+Valentia',
        },
    ];
    const savedUsers = await userRepo.save(userRepo.create(users));
    console.log(`✅ Berhasil membuat ${savedUsers.length} user:`);
    console.log(`   - 2 Admin (admin, eko.purnomo)`);
    console.log(`   - ${savedUsers.length - 2} Pegawai BPS Pringsewu`);
    return savedUsers;
}
async function seedBarang(dataSource) {
    const barangRepo = dataSource.getRepository(barang_entity_1.Barang);
    const barangList = [
        {
            nama_barang: 'SPIDOL PERMANENT',
            kode_barang: '1.01.03.01.001.000011',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BALLPOINT JELLER 100 JOYKO',
            kode_barang: '1.01.03.01.001.000017',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Binder Clip 105',
            kode_barang: '1.01.03.01.003.000001',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'TRIGONAL KLIP',
            kode_barang: '1.01.03.01.003.000004',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BINDER KLIP NO. 200',
            kode_barang: '1.01.03.01.003.000009',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'TRIGONAL KLIP NO.5',
            kode_barang: '1.01.03.01.003.000014',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'MAP LOGO',
            kode_barang: '1.01.03.01.006.000011',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'MAP TALI',
            kode_barang: '1.01.03.01.006.000031',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Map Arsip Keuangan',
            kode_barang: '1.01.03.01.006.000038',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'ISI CUTTER KECIL',
            kode_barang: '1.01.03.01.008.000004',
            kategori: 'ATK',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Gunting',
            kode_barang: '1.01.03.01.008.000012',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'LAKBAN BENING 2',
            kode_barang: '1.01.03.01.010.000009',
            kategori: 'ATK',
            satuan: 'Roll',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'LAKBAN COKLAT',
            kode_barang: '1.01.03.01.010.000013',
            kategori: 'ATK',
            satuan: 'Roll',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'LEM STIK BESAR',
            kode_barang: '1.01.03.01.010.000016',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Lem Cair',
            kode_barang: '1.01.03.01.010.000022',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Staples Sedang',
            kode_barang: '1.01.03.01.012.000012',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Isi Steples No 10',
            kode_barang: '1.01.03.01.013.000001',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'STICK NOTE',
            kode_barang: '1.01.03.01.999.000020',
            kategori: 'ATK',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'TIPE X ROLL',
            kode_barang: '1.01.03.01.999.000021',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PERUNCING JOYKO',
            kode_barang: '1.01.03.01.999.000030',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KERTAS HVS A4 70gr',
            kode_barang: '1.01.03.02.001.000006',
            kategori: 'Kertas',
            satuan: 'Rim',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kertas A3 70 gr',
            kode_barang: '1.01.03.02.001.000014',
            kategori: 'Kertas',
            satuan: 'Rim',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KERTAS A3 80 GR',
            kode_barang: '1.01.03.02.001.000018',
            kategori: 'Kertas',
            satuan: 'Rim',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KERTAS A4 SIDU 75 GR',
            kode_barang: '1.01.03.02.001.000021',
            kategori: 'Kertas',
            satuan: 'Rim',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kertas Sertifikat',
            kode_barang: '1.01.03.02.002.000015',
            kategori: 'Kertas',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Loose Leaf A5-100',
            kode_barang: '1.01.03.02.002.000018',
            kategori: 'Kertas',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'AMPLOP LOGO KECIL',
            kode_barang: '1.01.03.02.004.000007',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'AMPLOP LOGO SEDANG',
            kode_barang: '1.01.03.02.004.000008',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'AMPLOP',
            kode_barang: '1.01.03.02.004.000012',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'TONER 83A (CF 283 A)',
            kode_barang: '1.01.03.04.004.000077',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'REFILL TONER 83A',
            kode_barang: '1.01.03.04.004.000084',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'CATRIDGE TONER 85A',
            kode_barang: '1.01.03.04.004.000089',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'EPSON BLACK PIGMENT T7741',
            kode_barang: '1.01.03.04.004.000092',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'CATRIDGE TONER 89A',
            kode_barang: '1.01.03.04.004.000098',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 664 H',
            kode_barang: '1.01.03.04.004.000104',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'POWER BANK 10RB mAH',
            kode_barang: '1.01.03.99.999.000299',
            kategori: 'Elektronik',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'STABILO',
            kode_barang: '1.01.03.01.001.000013',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'TIZO GELLINER',
            kode_barang: '1.01.03.01.001.000033',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'SPIDOL WB BIRU',
            kode_barang: '1.01.03.01.001.000044',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'CLEAR HOLDER 20',
            kode_barang: '1.01.03.01.006.000033',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'AMPLOP BESAR',
            kode_barang: '1.01.03.02.004.000011',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tas Ransel ST2023',
            kode_barang: '1.01.03.99.999.000341',
            kategori: 'Merchandise',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Nametag ST2023',
            kode_barang: '1.01.03.99.999.000342',
            kategori: 'Merchandise',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Pensil 2B ST2023',
            kode_barang: '1.01.03.99.999.000343',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Block Note ST2023',
            kode_barang: '1.01.03.99.999.000344',
            kategori: 'ATK',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Peruncing ST2023',
            kode_barang: '1.01.03.99.999.000345',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Ballpoint ST2023',
            kode_barang: '1.01.03.99.999.000346',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Penghapus ST2023',
            kode_barang: '1.01.03.99.999.000347',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Papan Jalan ST2023',
            kode_barang: '1.01.03.99.999.000348',
            kategori: 'ATK',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tali ID Card ST2023',
            kode_barang: '1.01.03.99.999.000349',
            kategori: 'Merchandise',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Topi ST2023',
            kode_barang: '1.01.03.99.999.000350',
            kategori: 'Merchandise',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku 2A2 ST2023',
            kode_barang: '1.01.03.99.999.000351',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku 3A2 ST2023',
            kode_barang: '1.01.03.99.999.000352',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner ST2023-L2.UTP',
            kode_barang: '1.01.03.99.999.000353',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Spanduk ST2023',
            kode_barang: '1.01.03.99.999.000357',
            kategori: 'Media Publikasi',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'X Banner ST2023',
            kode_barang: '1.01.03.99.999.000358',
            kategori: 'Media Publikasi',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Dokumen Regsosek K',
            kode_barang: '1.01.03.99.999.000359',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BALLPOINT BOLLINER',
            kode_barang: '1.01.03.01.001.000001',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Ballpoint Bolliner Kotak',
            kode_barang: '1.01.03.01.001.000062',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Pena Joyko JK-100',
            kode_barang: '1.01.03.01.001.000063',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Pena 4 warna',
            kode_barang: '1.01.03.01.001.000065',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Trigonal Clip No1',
            kode_barang: '1.01.03.01.003.000022',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BUKU FOLIO',
            kode_barang: '1.01.03.01.005.000005',
            kategori: 'ATK',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'SOLATIF BESAR BENING',
            kode_barang: '1.01.03.01.010.000003',
            kategori: 'ATK',
            satuan: 'Roll',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'LAKBAN HITAM 2 in',
            kode_barang: '1.01.03.01.010.000010',
            kategori: 'ATK',
            satuan: 'Roll',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KALKULATOR',
            kode_barang: '1.01.03.01.999.000016',
            kategori: 'ATK',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Push Pins',
            kode_barang: '1.01.03.01.999.000039',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KERTAS FOTO',
            kode_barang: '1.01.03.02.002.000006',
            kategori: 'Kertas',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Flasdisk 64 Gb',
            kode_barang: '1.01.03.04.006.000009',
            kategori: 'Elektronik',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BATU BATERAI KECIL',
            kode_barang: '1.01.03.06.010.000001',
            kategori: 'Elektronik',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KERTAS HVS A4 80gr',
            kode_barang: '1.01.03.02.001.000005',
            kategori: 'Kertas',
            satuan: 'Rim',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Pensil 2B Faber Castel',
            kode_barang: '1.01.03.01.001.000028',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku 1 Pedoman Kepala',
            kode_barang: '1.01.03.99.999.000360',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku 2 Pedoman Pencacahan',
            kode_barang: '1.01.03.99.999.000361',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku 3 Pedoman Pengawas',
            kode_barang: '1.01.03.99.999.000362',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku 4 Konsep dan Definisi',
            kode_barang: '1.01.03.99.999.000363',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku 5 Pemanfaatan Data',
            kode_barang: '1.01.03.99.999.000364',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VSEN23.K',
            kode_barang: '1.01.03.99.999.000365',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VSEN23.KP',
            kode_barang: '1.01.03.99.999.000366',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VSEN23.P',
            kode_barang: '1.01.03.99.999.000367',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VSEN23.DSRT',
            kode_barang: '1.01.03.99.999.000368',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VSEN23.MHP',
            kode_barang: '1.01.03.99.999.000369',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Ballpoint SP2020',
            kode_barang: '1.01.03.99.999.000306',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tas SP2020',
            kode_barang: '1.01.03.99.999.000307',
            kategori: 'Merchandise',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 008 B',
            kode_barang: '1.01.03.04.004.000110',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 008 C',
            kode_barang: '1.01.03.04.004.000111',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 008 M',
            kode_barang: '1.01.03.04.004.000112',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'CATRIDGE TONER 83A',
            kode_barang: '1.01.03.04.004.000090',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'TEMPAT PENSIL',
            kode_barang: '1.01.03.01.999.000025',
            kategori: 'ATK',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Pena Gribell',
            kode_barang: '1.01.03.01.001.000053',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PENGHAPUS PENSIL BIASA',
            kode_barang: '1.01.03.01.004.000005',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Map Plastik',
            kode_barang: '1.01.03.01.006.000021',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PEMBOLONG KERTAS BESAR',
            kode_barang: '1.01.03.01.999.000002',
            kategori: 'ATK',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Post it',
            kode_barang: '1.01.03.01.999.000041',
            kategori: 'ATK',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Binder Clip 260',
            kode_barang: '1.01.03.01.003.000003',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BINDER KLIP NO. 107',
            kode_barang: '1.01.03.01.003.000012',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BLOK NOTE',
            kode_barang: '1.01.03.01.005.000004',
            kategori: 'ATK',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'LAKBAND HITAM 1,5 in',
            kode_barang: '1.01.03.01.010.000006',
            kategori: 'ATK',
            satuan: 'Roll',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KERTAS HVS F4 70gr',
            kode_barang: '1.01.03.02.001.000003',
            kategori: 'Kertas',
            satuan: 'Rim',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kertas Sidu A3 70 gr',
            kode_barang: '1.01.03.02.002.000022',
            kategori: 'Kertas',
            satuan: 'Rim',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'TONER 85A',
            kode_barang: '1.01.03.04.004.000083',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 003 C',
            kode_barang: '1.01.03.04.004.000100',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 003 M',
            kode_barang: '1.01.03.04.004.000101',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 003 Y',
            kode_barang: '1.01.03.04.004.000102',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 003 H',
            kode_barang: '1.01.03.04.004.000103',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 008 Y',
            kode_barang: '1.01.03.04.004.000113',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kertas Sidu F4 75 Gr',
            kode_barang: '1.01.03.02.001.000024',
            kategori: 'Kertas',
            satuan: 'Rim',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: "Kertas E'Paper F4 75 Gr",
            kode_barang: '1.01.03.02.001.000025',
            kategori: 'Kertas',
            satuan: 'Rim',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Binder klip No.280',
            kode_barang: '1.01.03.01.003.000020',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Stempel',
            kode_barang: '1.01.03.01.002.000001',
            kategori: 'ATK',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'refill toner 83A',
            kode_barang: '1.01.03.04.004.000108',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'refill toner 85A',
            kode_barang: '1.01.03.04.004.000082',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Map Kancing',
            kode_barang: '1.01.03.01.006.000042',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Paper sticker glossy',
            kode_barang: '1.01.03.02.002.000019',
            kategori: 'Kertas',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'CUTTER BESAR',
            kode_barang: '1.01.03.01.008.000001',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Sticky Note - Besar',
            kode_barang: '1.01.03.01.999.000031',
            kategori: 'ATK',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BATU ALKALIN',
            kode_barang: '1.01.03.06.010.000005',
            kategori: 'Elektronik',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Double Tape Kecil',
            kode_barang: '1.01.03.01.010.000021',
            kategori: 'ATK',
            satuan: 'Roll',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PENSIL TRACKPEN',
            kode_barang: '1.01.03.01.001.000036',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Pena Joyko BP-182',
            kode_barang: '1.01.03.01.001.000068',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PENGHAPUS PENSIL',
            kode_barang: '1.01.03.01.004.000001',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'TIPE X',
            kode_barang: '1.01.03.01.004.000004',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Isolasi',
            kode_barang: '1.01.03.01.010.000012',
            kategori: 'ATK',
            satuan: 'Roll',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BINDER KLIP NO. 111',
            kode_barang: '1.01.03.01.003.000011',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Stiker label',
            kode_barang: '1.01.03.02.002.000024',
            kategori: 'Kertas',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PEN MEJA',
            kode_barang: '1.01.03.01.001.000032',
            kategori: 'ATK',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'GLUE STICK',
            kode_barang: '1.01.03.01.010.000005',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Pena Tizo',
            kode_barang: '1.01.03.01.001.000069',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Spidol dan penghapus',
            kode_barang: '1.01.03.01.001.000067',
            kategori: 'ATK',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Box File Jaring Besi 3 tingkat',
            kode_barang: '1.01.03.01.006.000035',
            kategori: 'ATK',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 664 C',
            kode_barang: '1.01.03.04.004.000114',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 664 M',
            kode_barang: '1.01.03.04.004.000115',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BINDER KLIP NO. 1',
            kode_barang: '1.01.03.01.003.000019',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Sticky note kecil',
            kode_barang: '1.01.03.01.999.000046',
            kategori: 'ATK',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Ballpoint ZRM Penkita',
            kode_barang: '1.01.03.01.001.000070',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PENSIL 2B FABER CASTLE',
            kode_barang: '1.01.03.01.001.000008',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Lem Stik',
            kode_barang: '1.01.03.01.010.000007',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Stapler',
            kode_barang: '1.01.03.01.999.000044',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Gunting Sedang',
            kode_barang: '1.01.03.01.008.000014',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Sticky Note - Sedang',
            kode_barang: '1.01.03.01.999.000032',
            kategori: 'ATK',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'UDPE 2023',
            kode_barang: '1.01.03.99.999.000398',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman SINASI',
            kode_barang: '1.01.03.99.999.000400',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner SINASI',
            kode_barang: '1.01.03.99.999.000401',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'VSERUTI23.INTI',
            kode_barang: '1.01.03.99.999.000399',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB MI01-Perkebunan',
            kode_barang: '1.01.03.99.999.000387',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB MI02-Hortikultura',
            kode_barang: '1.01.03.99.999.000388',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB MI03-Hewan',
            kode_barang: '1.01.03.99.999.000389',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB-MI09-IMB',
            kode_barang: '1.01.03.99.999.000390',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB MI10-PBB',
            kode_barang: '1.01.03.99.999.000391',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB MI11-LKPM',
            kode_barang: '1.01.03.99.999.000392',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB MI07C-APBDESA',
            kode_barang: '1.01.03.99.999.000393',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB KORPORASI FINANSIAL MIP-01',
            kode_barang: '1.01.03.99.999.000394',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB KORPORASI NON FINANSIAL MIP-01',
            kode_barang: '1.01.03.99.999.000395',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB RUMAH TANGGA MI-RT',
            kode_barang: '1.01.03.99.999.000396',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PMTB LNPRT MI-LNPRT',
            kode_barang: '1.01.03.99.999.000397',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Statistik Daerah Kabupaten Pringsewu 2023',
            kode_barang: '1.01.03.99.999.000376',
            kategori: 'Publikasi',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Indikator Kesejahteraan Rakyat Kabupaten Pringsewu 2023',
            kode_barang: '1.01.03.99.999.000377',
            kategori: 'Publikasi',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Produk Domestik Regional Bruto Kabupaten Pringsewu Menurut Pengeluaran 2018-2022',
            kode_barang: '1.01.03.99.999.000381',
            kategori: 'Publikasi',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Produk Domestik Regional Bruto Kabupaten Pringsewu Menurut Lapangan Usaha 2018-2022',
            kode_barang: '1.01.03.99.999.000382',
            kategori: 'Publikasi',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Statistik Kesejahteraan Rakyat Kabupaten Pringsewu 2023',
            kode_barang: '1.01.03.99.999.000378',
            kategori: 'Publikasi',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Statistik Ketenagakerjaan Kabupaten Pringsewu 2022',
            kode_barang: '1.01.03.99.999.000379',
            kategori: 'Publikasi',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Hasil Long Form Sensus Penduduk 2020 Kabupaten Pringsewu',
            kode_barang: '1.01.03.99.999.000383',
            kategori: 'Publikasi',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Booklet Data Strategis Kabupaten Pringsewu 2018-2022',
            kode_barang: '1.01.03.99.999.000380',
            kategori: 'Publikasi',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kabupaten Pringsewu Dalam Angka 2023 Hc',
            kode_barang: '1.01.03.99.999.000385',
            kategori: 'Publikasi',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Kasus Batas KBLI Industri',
            kode_barang: '1.01.03.99.999.000403',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner SKSPPI',
            kode_barang: '1.01.03.99.999.000408',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman SKSPPI',
            kode_barang: '1.01.03.99.999.000409',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner SKLNP',
            kode_barang: '1.01.03.99.999.000410',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman SKLNP',
            kode_barang: '1.01.03.99.999.000411',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner SKPS',
            kode_barang: '1.01.03.99.999.000412',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman SKPS',
            kode_barang: '1.01.03.99.999.000413',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman Pencacahan Sakernas',
            kode_barang: '1.01.03.99.999.000404',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman Pengawasan Sakernas',
            kode_barang: '1.01.03.99.999.000405',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner SAK.AGS23-AK',
            kode_barang: '1.01.03.99.999.000407',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Dokumen VIMK23-Tahunan S2',
            kode_barang: '1.01.03.99.999.000402',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VHTL',
            kode_barang: '1.01.03.99.999.000414',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman VHTL',
            kode_barang: '1.01.03.99.999.000415',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VDTW',
            kode_barang: '1.01.03.99.999.000416',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman VDTW',
            kode_barang: '1.01.03.99.999.000417',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VREST UMB',
            kode_barang: '1.01.03.99.999.000418',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman VREST UMB',
            kode_barang: '1.01.03.99.999.000419',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'SKTH 2022',
            kode_barang: '1.01.03.99.999.000420',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'SKP23-S',
            kode_barang: '1.01.03.99.999.000421',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Pedoman Survei Konstruksi',
            kode_barang: '1.01.03.99.999.000422',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Surat Rekomendasi PU',
            kode_barang: '1.01.03.99.999.000423',
            kategori: 'Dokumen',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Surat Pengantar BPS',
            kode_barang: '1.01.03.99.999.000424',
            kategori: 'Dokumen',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kartu Kendali Survei Konstruksi',
            kode_barang: '1.01.03.99.999.000425',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Leaflet Statistik Konstruksi',
            kode_barang: '1.01.03.99.999.000426',
            kategori: 'Media Publikasi',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner Galian URT',
            kode_barang: '1.01.03.99.999.000427',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner Air Bersih',
            kode_barang: '1.01.03.99.999.000428',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner Air Bersih Triwulanan',
            kode_barang: '1.01.03.99.999.000429',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner Captive Power',
            kode_barang: '1.01.03.99.999.000430',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Updating Desa Penggalian',
            kode_barang: '1.01.03.99.999.000431',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman Pertambangan dan Energi',
            kode_barang: '1.01.03.99.999.000432',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner STIPM IIA Th 2023',
            kode_barang: '1.01.03.99.999.000434',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'kartu Kendali Survei IBS',
            kode_barang: '1.01.03.99.999.000435',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Amplop Coklat Survei IBS',
            kode_barang: '1.01.03.99.999.000436',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Frame Piagam Perusahaan',
            kode_barang: '1.01.03.99.999.000437',
            kategori: 'Lain-lain',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VIMK23-L2',
            kode_barang: '1.01.03.99.999.000438',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'VSERUTI23.MAK',
            kode_barang: '1.01.03.99.999.000433',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Binder Clip 155',
            kode_barang: '1.01.03.01.003.000002',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Binder Clip 107',
            kode_barang: '1.01.03.01.003.000021',
            kategori: 'ATK',
            satuan: 'Box',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'CLEAR HOLDER 40',
            kode_barang: '1.01.03.01.006.000032',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Staples',
            kode_barang: '1.01.03.01.999.000045',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tinta Epson 664 Y',
            kode_barang: '1.01.03.04.004.000116',
            kategori: 'Perlengkapan Komputer',
            satuan: 'Botol',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PEMBATAS BUKU',
            kode_barang: '1.01.03.01.999.000011',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Gunting Besar',
            kode_barang: '1.01.03.01.008.000013',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KALENDER DINDING',
            kode_barang: '1.01.03.99.999.000125',
            kategori: 'Media Publikasi',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KALENDER MEJA',
            kode_barang: '1.01.03.99.999.000126',
            kategori: 'Media Publikasi',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BUKU KERJA',
            kode_barang: '1.01.03.99.999.000127',
            kategori: 'ATK',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VSEN24.K',
            kode_barang: '1.01.03.99.999.000439',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VSEN24.KP',
            kode_barang: '1.01.03.99.999.000440',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner Survei Komoditas Industri Manufaktur (SKIM)',
            kode_barang: '1.01.03.99.999.000468',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner Galian BH',
            kode_barang: '1.01.03.99.999.000469',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner Galian BH Triwulanan',
            kode_barang: '1.01.03.99.999.000470',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Dokumen ST2023.SEP.UTP',
            kode_barang: '1.01.03.99.999.000455',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'AMPLOP COKLAT',
            kode_barang: '1.01.03.99.999.000292',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VIMK24-S2',
            kode_barang: '1.01.03.99.999.000466',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner Survei Tahunan Perusahaan Industri Manufaktur (STPIM)',
            kode_barang: '1.01.03.99.999.000467',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Pena Joyko JK-100 Merah',
            kode_barang: '1.01.03.01.001.000071',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Fineliner',
            kode_barang: '1.01.03.01.001.000072',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Double Tape',
            kode_barang: '1.01.03.01.010.000008',
            kategori: 'ATK',
            satuan: 'Roll',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kertas BC LN Putih Folio',
            kode_barang: '1.01.03.02.002.000025',
            kategori: 'Kertas',
            satuan: 'Rim',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kertas KS Photo Double Side Matte',
            kode_barang: '1.01.03.02.002.000026',
            kategori: 'Kertas',
            satuan: 'Pack',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PENGHAPUS PENSIL JOYKO',
            kode_barang: '1.01.03.01.004.000006',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner Survei K3',
            kode_barang: '1.01.03.99.999.000448',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kueioner Statistik Keuangan BUMD',
            kode_barang: '1.01.03.99.999.000449',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner SLK-VALAS',
            kode_barang: '1.01.03.99.999.000450',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner SLK-KSP',
            kode_barang: '1.01.03.99.999.000451',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Kode',
            kode_barang: '1.01.03.99.999.000406',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner VSEN24.P',
            kode_barang: '1.01.03.99.999.000441',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'VSEN24.DSRT',
            kode_barang: '1.01.03.99.999.000442',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'VSEN24.MHP',
            kode_barang: '1.01.03.99.999.000443',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'VSERUTI24.INTI',
            kode_barang: '1.01.03.99.999.000445',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman Pencacahan',
            kode_barang: '1.01.03.99.999.000446',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Buku Pedoman Pemeriksaan',
            kode_barang: '1.01.03.99.999.000447',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KUESIONER HD 1',
            kode_barang: '1.01.03.99.999.000133',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KUESIONER HD 2',
            kode_barang: '1.01.03.99.999.000134',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KUESIONER HD 3',
            kode_barang: '1.01.03.99.999.000135',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KUESIONER HD 4',
            kode_barang: '1.01.03.99.999.000136',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KUESIONER HD 5.2',
            kode_barang: '1.01.03.99.999.000137',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BUKU PEDOMAN HKD',
            kode_barang: '1.01.03.99.999.000144',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BUKU PEDOMAN HD',
            kode_barang: '1.01.03.99.999.000145',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KUESIONER HP',
            kode_barang: '1.01.03.99.999.000180',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'KUESIONER HP-JTB',
            kode_barang: '1.01.03.99.999.000254',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BUKU PEDOMAN PENCACAHAN SURVEI HP',
            kode_barang: '1.01.03.99.999.000284',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BUKU PEDOMAN PEMERIKSAAN SURVEI HP',
            kode_barang: '1.01.03.99.999.000285',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BUKU PEDOMAN PENCACAHAN SURVEI HPBG',
            kode_barang: '1.01.03.99.999.000286',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'BUKU PEDOMAN PEMERIKSAAN SURVEI HPBG',
            kode_barang: '1.01.03.99.999.000287',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kuesioner HPG',
            kode_barang: '1.01.03.99.999.000452',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Pedoman Pengolahan',
            kode_barang: '1.01.03.99.999.000453',
            kategori: 'Dokumen Survei',
            satuan: 'Buku',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Suplemen HP',
            kode_barang: '1.01.03.99.999.000454',
            kategori: 'Dokumen Survei',
            satuan: 'Set',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'SPIDOL WB HITAM',
            kode_barang: '1.01.03.01.001.000043',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Solatip Panfix 1/2x10',
            kode_barang: '1.01.03.01.010.000020',
            kategori: 'ATK',
            satuan: 'Roll',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tape Cutter',
            kode_barang: '1.01.03.01.999.000048',
            kategori: 'ATK',
            satuan: 'Buah',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Kertas Koran',
            kode_barang: '1.01.03.02.002.000021',
            kategori: 'Kertas',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'PENGHAPUS FABER CASTEL',
            kode_barang: '1.01.03.01.004.000008',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Stabilo Joyko',
            kode_barang: '1.01.03.01.001.000029',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Spidol Snowman',
            kode_barang: '1.01.03.01.001.000027',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'VSEN24.DSBS',
            kode_barang: '1.01.03.99.999.000444',
            kategori: 'Dokumen Survei',
            satuan: 'Lembar',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'JOYKO STAPLER',
            kode_barang: '1.01.03.01.012.000004',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'Tipe X Cair',
            kode_barang: '1.01.03.01.999.000047',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
        {
            nama_barang: 'SNOWMAN BP 7',
            kode_barang: '1.01.03.01.001.000031',
            kategori: 'ATK',
            satuan: 'Pcs',
            stok: 0,
            ambang_batas_kritis: 0,
            status_aktif: true,
        },
    ];
    await barangRepo.save(barangRepo.create(barangList));
    console.log(`✅ Berhasil membuat ${barangList.length} barang`);
}
seed().catch((err) => {
    console.error('Seeding gagal:', err);
    process.exit(1);
});
//# sourceMappingURL=seeder.js.map