import { Permintaan } from '../entities/permintaan.entity';
import { DetailPermintaan } from '../entities/detail_permintaan.entity';
import { Barang } from '../entities/barang.entity';
import { User } from '../entities/user.entity';
import { Repository, DataSource } from 'typeorm';
import { CreatePermintaanDto } from './dto/create-permintaan.dto';
import { VerifikasiPermintaanDto } from './dto/verifikasi-permintaan.dto';
export declare class PermintaanService {
    private permintaanRepo;
    private detailRepo;
    private barangRepo;
    private userRepo;
    private dataSource;
    constructor(permintaanRepo: Repository<Permintaan>, detailRepo: Repository<DetailPermintaan>, barangRepo: Repository<Barang>, userRepo: Repository<User>, dataSource: DataSource);
    create(dto: CreatePermintaanDto, userId: number): Promise<{
        items: DetailPermintaan[];
        id: number;
        id_user_pemohon: number;
        pemohon: User;
        tanggal_permintaan: Date;
        status: "Menunggu" | "Disetujui" | "Disetujui Sebagian" | "Ditolak";
        catatan?: string;
        id_user_verifikator?: number;
        tanggal_verifikasi?: Date;
        created_at: Date;
        updated_at: Date;
        details: DetailPermintaan[];
    }>;
    getRiwayatByUser(userId: number): Promise<{
        items: DetailPermintaan[];
        id: number;
        id_user_pemohon: number;
        pemohon: User;
        tanggal_permintaan: Date;
        status: "Menunggu" | "Disetujui" | "Disetujui Sebagian" | "Ditolak";
        catatan?: string;
        id_user_verifikator?: number;
        tanggal_verifikasi?: Date;
        created_at: Date;
        updated_at: Date;
        details: DetailPermintaan[];
    }[]>;
    findOneById(id: number): Promise<{
        items: DetailPermintaan[];
        id: number;
        id_user_pemohon: number;
        pemohon: User;
        tanggal_permintaan: Date;
        status: "Menunggu" | "Disetujui" | "Disetujui Sebagian" | "Ditolak";
        catatan?: string;
        id_user_verifikator?: number;
        tanggal_verifikasi?: Date;
        created_at: Date;
        updated_at: Date;
        details: DetailPermintaan[];
    }>;
    getPermintaanMenunggu(): Promise<Permintaan[]>;
    verifikasiPermintaan(id: number, dto: VerifikasiPermintaanDto, verifikatorId: number): Promise<{
        items: DetailPermintaan[];
        id: number;
        id_user_pemohon: number;
        pemohon: User;
        tanggal_permintaan: Date;
        status: "Menunggu" | "Disetujui" | "Disetujui Sebagian" | "Ditolak";
        catatan?: string;
        id_user_verifikator?: number;
        tanggal_verifikasi?: Date;
        created_at: Date;
        updated_at: Date;
        details: DetailPermintaan[];
    }>;
    getDashboardStatistik(): Promise<{
        totalBarang: number;
        totalPermintaanTertunda: number;
        totalBarangKritis: number;
        totalUser: number;
    }>;
    getTrenPermintaanBulanan(): Promise<{
        bulan: string;
        jumlah: number;
    }[]>;
    generateBuktiPermintaanPDF(id: number): Promise<Buffer>;
    getAllPermintaan({ status, page, limit, }: {
        status?: string;
        page?: number;
        limit?: number;
    }): Promise<{
        data: Permintaan[];
        total: number;
        page: number;
        limit: number;
    }>;
}
