"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BarangService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const barang_entity_1 = require("../entities/barang.entity");
const typeorm_2 = require("typeorm");
const PdfPrinter = __importStar(require("pdfmake"));
const path = __importStar(require("path"));
let BarangService = class BarangService {
    barangRepo;
    dataSource;
    constructor(barangRepo, dataSource) {
        this.barangRepo = barangRepo;
        this.dataSource = dataSource;
    }
    async create(dto) {
        const barangSudahAda = await this.barangRepo.findOne({
            where: { kode_barang: dto.kode_barang },
        });
        if (barangSudahAda) {
            throw new common_1.BadRequestException('Kode barang sudah terdaftar');
        }
        const barangBaru = this.barangRepo.create({ ...dto, status_aktif: true });
        return this.barangRepo.save(barangBaru);
    }
    async findAll(query) {
        const qb = this.barangRepo.createQueryBuilder('barang');
        if (query?.q) {
            qb.andWhere('(barang.nama_barang ILIKE :q OR barang.kode_barang ILIKE :q)', { q: `%${query.q}%` });
        }
        if (typeof query?.status_aktif === 'boolean') {
            qb.andWhere('barang.status_aktif = :status', {
                status: query.status_aktif,
            });
        }
        if (query?.stok_kritis) {
            qb.andWhere('barang.stok <= barang.ambang_batas_kritis');
        }
        return qb.getMany();
    }
    async findOne(id) {
        const barang = await this.barangRepo.findOne({ where: { id } });
        if (!barang) {
            throw new common_1.NotFoundException('Barang tidak ditemukan');
        }
        return barang;
    }
    async update(id, dto) {
        if (dto.stok !== undefined && dto.stok < 0) {
            throw new common_1.BadRequestException('Stok tidak boleh negatif');
        }
        const barang = await this.findOne(id);
        Object.assign(barang, dto);
        return this.barangRepo.save(barang);
    }
    async softDelete(id) {
        const barang = await this.findOne(id);
        barang.status_aktif = false;
        return this.barangRepo.save(barang);
    }
    async remove(id) {
        const barang = await this.findOne(id);
        await this.barangRepo.remove(barang);
    }
    async addStok(id, dto) {
        if (dto.jumlah < 1) {
            throw new common_1.BadRequestException('Jumlah penambahan stok minimal 1');
        }
        const barang = await this.findOne(id);
        if (!barang.status_aktif) {
            throw new common_1.BadRequestException('Barang tidak aktif');
        }
        barang.stok = (barang.stok ?? 0) + dto.jumlah;
        return this.barangRepo.save(barang);
    }
    async getStokKritis() {
        return this.barangRepo
            .createQueryBuilder('barang')
            .where('barang.stok <= barang.ambang_batas_kritis')
            .andWhere('barang.status_aktif = :aktif', { aktif: true })
            .getMany();
    }
    async getBarangKritis() {
        return this.barangRepo
            .createQueryBuilder('barang')
            .where('barang.stok <= barang.ambang_batas_kritis')
            .andWhere('barang.status_aktif = :aktif', { aktif: true })
            .orderBy('barang.stok', 'ASC')
            .getMany();
    }
    async generateLaporanPenggunaanPDF(start, end, unitKerja) {
        try {
            const penggunaan = await this.getLaporanPenggunaanJSON(start, end, unitKerja);
            const formatDate = (dateStr) => {
                const date = new Date(dateStr);
                const day = String(date.getDate()).padStart(2, '0');
                const month = date.getMonth() + 1;
                const year = date.getFullYear();
                return `${day}/${month}/${year}`;
            };
            const formatDateFull = (dateStr) => {
                const date = new Date(dateStr);
                const namaBulan = [
                    'Januari',
                    'Februari',
                    'Maret',
                    'April',
                    'Mei',
                    'Juni',
                    'Juli',
                    'Agustus',
                    'September',
                    'Oktober',
                    'November',
                    'Desember',
                ];
                const day = String(date.getDate()).padStart(2, '0');
                const month = date.getMonth();
                const year = date.getFullYear();
                return `${day} ${namaBulan[month]} ${year}`;
            };
            const today = new Date();
            const currentDateString = formatDateFull(today.toISOString().split('T')[0]);
            const startFormatted = formatDateFull(start);
            const endFormatted = formatDateFull(end);
            const fonts = {
                Roboto: {
                    normal: path.join(__dirname, '../assets/fonts/Roboto-Regular.ttf'),
                    bold: path.join(__dirname, '../assets/fonts/Roboto-Bold.ttf'),
                    italics: path.join(__dirname, '../assets/fonts/Roboto-Italic.ttf'),
                    bolditalics: path.join(__dirname, '../assets/fonts/Roboto-BoldItalic.ttf'),
                },
            };
            const printer = new PdfPrinter(fonts);
            const logoPath = path.join(__dirname, '../assets/images/logo-bps-pringsewu.png');
            const bodyRows = penggunaan.length > 0
                ? penggunaan.map((row, index) => [
                    { text: index + 1, alignment: 'center' },
                    row.nama_barang,
                    { text: row.kode_barang, alignment: 'center' },
                    { text: row.total_digunakan, alignment: 'center' },
                    row.satuan,
                    { text: formatDate(row.tanggal_permintaan), alignment: 'center' },
                ])
                : [
                    [
                        {
                            text: 'Tidak ada data penggunaan barang dalam periode ini',
                            colSpan: 6,
                            alignment: 'center',
                        },
                        {},
                        {},
                        {},
                        {},
                        {},
                    ],
                ];
            const docDefinition = {
                pageSize: 'A4',
                pageMargins: [40, 60, 40, 60],
                content: [
                    {
                        columns: [
                            { width: 170, image: logoPath, fit: [170, 85] },
                            { width: '*', text: '' },
                        ],
                    },
                    {
                        text: 'Laporan Penggunaan',
                        style: 'header',
                        alignment: 'center',
                        margin: [0, 10, 0, 0],
                    },
                    {
                        text: 'Barang Persediaan',
                        style: 'header',
                        alignment: 'center',
                        margin: [0, 0, 0, 15],
                    },
                    unitKerja
                        ? {
                            text: unitKerja,
                            style: 'unitKerja',
                            margin: [0, 0, 0, 20],
                        }
                        : {},
                    {
                        columns: [
                            {
                                width: '100%',
                                text: [
                                    { text: 'Periode: ', style: 'labelInfo' },
                                    {
                                        text: `${startFormatted} s/d ${endFormatted}`,
                                        style: 'valueInfo',
                                    },
                                ],
                                alignment: 'center',
                            },
                        ],
                        margin: [0, 0, 0, 20],
                    },
                    {
                        table: {
                            headerRows: 1,
                            widths: [30, '*', 70, 60, 50, 80],
                            body: [
                                [
                                    { text: 'No', style: 'tableHeader' },
                                    { text: 'Nama Barang', style: 'tableHeader' },
                                    { text: 'Kode Barang', style: 'tableHeader' },
                                    { text: 'Jumlah', style: 'tableHeader' },
                                    { text: 'Satuan', style: 'tableHeader' },
                                    { text: 'Tanggal Permintaan', style: 'tableHeader' },
                                ],
                                ...bodyRows,
                            ],
                        },
                        layout: {
                            hLineWidth: (i, node) => i === 0 || i === 1 || i === node.table.body.length ? 1 : 0.5,
                            vLineWidth: () => 0.5,
                            hLineColor: (i, node) => i === 0 || i === 1 || i === node.table.body.length
                                ? '#aaaaaa'
                                : '#dddddd',
                            vLineColor: () => '#aaaaaa',
                            paddingLeft: () => 8,
                            paddingRight: () => 8,
                            paddingTop: () => 8,
                            paddingBottom: () => 8,
                        },
                    },
                    {
                        columns: [
                            {
                                width: '50%',
                                stack: [
                                    {
                                        text: `\n\n\n`,
                                        margin: [0, 20, 0, 15],
                                    },
                                    { text: 'Kasubag Umum', margin: [0, 0, 0, 40] },
                                    { text: 'Ambriyanto, S.E.', fontSize: 12 },
                                ],
                                alignment: 'left',
                            },
                            {
                                width: '50%',
                                stack: [
                                    {
                                        text: `\n\nPringsewu, ${currentDateString}`,
                                        margin: [0, 20, 0, 15],
                                    },
                                    { text: 'Kepala BPS Pringsewu', margin: [0, 0, 0, 40] },
                                    { text: 'Dr. Budi Pranoto, M.Si', fontSize: 12 },
                                ],
                                alignment: 'left',
                            },
                        ],
                    },
                ],
                styles: {
                    header: {
                        fontSize: 16,
                        bold: true,
                        color: '#000000',
                    },
                    unitKerja: {
                        fontSize: 12,
                        bold: true,
                        color: '#000000',
                    },
                    tableHeader: {
                        bold: true,
                        fontSize: 10,
                        fillColor: '#f1f5f9',
                        color: '#000000',
                        alignment: 'center',
                        margin: [0, 4],
                    },
                    labelInfo: {
                        fontSize: 10,
                        color: '#000000',
                    },
                    valueInfo: {
                        fontSize: 10,
                        bold: true,
                        color: '#000000',
                    },
                },
                footer: {
                    columns: [
                        {
                            text: 'SIAP BPS Pringsewu',
                            alignment: 'center',
                            fontSize: 8,
                            color: '#000000',
                            margin: [0, 10, 0, 0],
                        },
                    ],
                },
            };
            const pdfDoc = printer.createPdfKitDocument(docDefinition);
            const chunks = [];
            return new Promise((resolve, reject) => {
                pdfDoc.on('data', (chunk) => chunks.push(chunk));
                pdfDoc.on('end', () => resolve(Buffer.concat(chunks)));
                pdfDoc.on('error', (err) => {
                    console.error('PDF generation error:', err);
                    reject(err);
                });
                pdfDoc.end();
            });
        }
        catch (error) {
            console.error('Error in PDF generation:', error);
            throw error;
        }
    }
    async getLaporanPenggunaanJSON(start, end, unitKerja) {
        if (!/^\d{4}-\d{2}-\d{2}$/.test(start) ||
            !/^\d{4}-\d{2}-\d{2}$/.test(end)) {
            throw new common_1.BadRequestException('Format tanggal harus YYYY-MM-DD');
        }
        if (new Date(start) > new Date(end)) {
            throw new common_1.BadRequestException('Tanggal mulai harus <= tanggal akhir');
        }
        const qb = this.dataSource
            .createQueryBuilder()
            .select([
            'b.nama_barang AS nama_barang',
            'b.kode_barang AS kode_barang',
            'b.satuan AS satuan',
            'SUM(dp.jumlah_disetujui) AS total_digunakan',
            'u.unit_kerja AS unit_kerja',
            'MIN(p.tanggal_permintaan) AS tanggal_permintaan',
        ])
            .from('detail_permintaan', 'dp')
            .innerJoin('barang', 'b', 'dp.id_barang = b.id')
            .innerJoin('permintaan', 'p', 'dp.id_permintaan = p.id')
            .innerJoin('users', 'u', 'p.id_user_pemohon = u.id')
            .where('p.status IN (:...statuses)', {
            statuses: ['Disetujui', 'Disetujui Sebagian'],
        })
            .andWhere('p.tanggal_verifikasi >= :start', { start })
            .andWhere('p.tanggal_verifikasi <= :end', { end })
            .andWhere('dp.jumlah_disetujui > 0')
            .groupBy('b.nama_barang')
            .addGroupBy('b.kode_barang')
            .addGroupBy('b.satuan')
            .addGroupBy('u.unit_kerja')
            .orderBy('b.nama_barang', 'ASC');
        if (unitKerja) {
            qb.andWhere('u.unit_kerja = :unitKerja', { unitKerja });
        }
        return qb.getRawMany();
    }
};
exports.BarangService = BarangService;
exports.BarangService = BarangService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(barang_entity_1.Barang)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.DataSource])
], BarangService);
//# sourceMappingURL=barang.service.js.map