"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BarangController = void 0;
const common_1 = require("@nestjs/common");
const passport_1 = require("@nestjs/passport");
const roles_guard_1 = require("../auth/roles.guard");
const roles_decorator_1 = require("../auth/roles.decorator");
const barang_service_1 = require("./barang.service");
const create_barang_dto_1 = require("./dto/create-barang.dto");
const update_barang_dto_1 = require("./dto/update-barang.dto");
const add_stok_dto_1 = require("./dto/add-stok.dto");
const jwt_auth_guard_1 = require("../auth/jwt-auth.guard");
let BarangController = class BarangController {
    barangService;
    constructor(barangService) {
        this.barangService = barangService;
    }
    create(dto) {
        return this.barangService.create(dto);
    }
    findAll(q, status_aktif, stok_kritis) {
        return this.barangService.findAll({
            q,
            status_aktif: status_aktif === undefined ? undefined : status_aktif === 'true',
            stok_kritis: stok_kritis === 'true',
        });
    }
    async getStokKritis() {
        return this.barangService.getStokKritis();
    }
    async getNotifikasiStokKritis() {
        return this.barangService.getBarangKritis();
    }
    async getLaporanPenggunaanJSON(start, end, unitKerja) {
        if (!/^\d{4}-\d{2}-\d{2}$/.test(start) ||
            !/^\d{4}-\d{2}-\d{2}$/.test(end)) {
            throw new common_1.BadRequestException('Format tanggal harus YYYY-MM-DD');
        }
        if (new Date(start) > new Date(end)) {
            throw new common_1.BadRequestException('Tanggal mulai harus <= tanggal akhir');
        }
        return await this.barangService.getLaporanPenggunaanJSON(start, end, unitKerja);
    }
    async generateLaporanPenggunaanPDF(start, end, unitKerja, res) {
        if (!/^\d{4}-\d{2}-\d{2}$/.test(start) ||
            !/^\d{4}-\d{2}-\d{2}$/.test(end)) {
            throw new common_1.BadRequestException('Format tanggal harus YYYY-MM-DD');
        }
        if (new Date(start) > new Date(end)) {
            throw new common_1.BadRequestException('Tanggal mulai harus <= tanggal akhir');
        }
        const pdfBuffer = await this.barangService.generateLaporanPenggunaanPDF(start, end, unitKerja);
        res.set({
            'Content-Type': 'application/pdf',
            'Content-Disposition': `attachment; filename="laporan_penggunaan_${start}_${end}.pdf"`,
        });
        res.end(pdfBuffer);
    }
    getAvailableBarang() {
        return this.barangService.findAll({
            status_aktif: true,
        });
    }
    findOne(id) {
        return this.barangService.findOne(id);
    }
    update(id, dto) {
        return this.barangService.update(id, dto);
    }
    addStok(id, dto) {
        return this.barangService.addStok(id, dto);
    }
    softDelete(id) {
        return this.barangService.softDelete(id);
    }
};
exports.BarangController = BarangController;
__decorate([
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)(new common_1.ValidationPipe({
        whitelist: true,
        forbidNonWhitelisted: true,
        transform: true,
    }))),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_barang_dto_1.CreateBarangDto]),
    __metadata("design:returntype", void 0)
], BarangController.prototype, "create", null);
__decorate([
    (0, roles_decorator_1.Roles)('admin', 'pegawai'),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('q')),
    __param(1, (0, common_1.Query)('status_aktif')),
    __param(2, (0, common_1.Query)('stok_kritis')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String]),
    __metadata("design:returntype", void 0)
], BarangController.prototype, "findAll", null);
__decorate([
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Get)('stok-kritis'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], BarangController.prototype, "getStokKritis", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('dashboard/notifikasi-stok-kritis'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], BarangController.prototype, "getNotifikasiStokKritis", null);
__decorate([
    (0, common_1.Get)('laporan-penggunaan'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Query)('start')),
    __param(1, (0, common_1.Query)('end')),
    __param(2, (0, common_1.Query)('unit_kerja')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String]),
    __metadata("design:returntype", Promise)
], BarangController.prototype, "getLaporanPenggunaanJSON", null);
__decorate([
    (0, common_1.Get)('laporan-penggunaan/pdf'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Query)('start')),
    __param(1, (0, common_1.Query)('end')),
    __param(2, (0, common_1.Query)('unit_kerja')),
    __param(3, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String, Object]),
    __metadata("design:returntype", Promise)
], BarangController.prototype, "generateLaporanPenggunaanPDF", null);
__decorate([
    (0, common_1.Get)('available'),
    (0, roles_decorator_1.Roles)('pegawai'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], BarangController.prototype, "getAvailableBarang", null);
__decorate([
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], BarangController.prototype, "findOne", null);
__decorate([
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, update_barang_dto_1.UpdateBarangDto]),
    __metadata("design:returntype", void 0)
], BarangController.prototype, "update", null);
__decorate([
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Patch)(':id/add-stok'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, add_stok_dto_1.AddStokDto]),
    __metadata("design:returntype", void 0)
], BarangController.prototype, "addStok", null);
__decorate([
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], BarangController.prototype, "softDelete", null);
exports.BarangController = BarangController = __decorate([
    (0, common_1.Controller)('barang'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    __metadata("design:paramtypes", [barang_service_1.BarangService])
], BarangController);
//# sourceMappingURL=barang.controller.js.map