import { BarangService } from './barang.service';
import { CreateBarangDto } from './dto/create-barang.dto';
import { UpdateBarangDto } from './dto/update-barang.dto';
import { AddStokDto } from './dto/add-stok.dto';
import { Response } from 'express';
export declare class BarangController {
    private readonly barangService;
    constructor(barangService: BarangService);
    create(dto: CreateBarangDto): Promise<import("../entities/barang.entity").Barang>;
    findAll(q?: string, status_aktif?: string, stok_kritis?: string): Promise<import("../entities/barang.entity").Barang[]>;
    getStokKritis(): Promise<import("../entities/barang.entity").Barang[]>;
    getNotifikasiStokKritis(): Promise<import("../entities/barang.entity").Barang[]>;
    getLaporanPenggunaanJSON(start: string, end: string, unitKerja: string): Promise<any[]>;
    generateLaporanPenggunaanPDF(start: string, end: string, unitKerja: string, res: Response): Promise<void>;
    getAvailableBarang(): Promise<import("../entities/barang.entity").Barang[]>;
    findOne(id: number): Promise<import("../entities/barang.entity").Barang>;
    update(id: number, dto: UpdateBarangDto): Promise<import("../entities/barang.entity").Barang>;
    addStok(id: number, dto: AddStokDto): Promise<import("../entities/barang.entity").Barang>;
    softDelete(id: number): Promise<import("../entities/barang.entity").Barang>;
}
