import { UserService } from '../user/user.service';
import { JwtService } from '@nestjs/jwt';
export declare class AuthService {
    private readonly userService;
    private readonly jwtService;
    private readonly tokenBlacklist;
    constructor(userService: UserService, jwtService: JwtService);
    validateUser(username: string, password: string): Promise<Omit<any, 'password'> | null>;
    login(username: string, password: string): Promise<{
        access_token: string;
        user: any;
    }>;
    logout(token: string): {
        message: string;
    };
    isTokenBlacklisted(token: string): boolean;
}
