import { MigrationInterface, QueryRunner } from "typeorm";

export class AddKategoriToBarang1756980895511 implements MigrationInterface {
    name = 'AddKategoriToBarang1756980895511'

    public async up(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "permintaan" RENAME COLUMN "catatan_admin" TO "catatan"`);
        await queryRunner.query(`ALTER TABLE "barang" ADD "kategori" character varying`);
        await queryRunner.query(`ALTER TABLE "users" DROP COLUMN "role"`);
        await queryRunner.query(`CREATE TYPE "public"."users_role_enum" AS ENUM('admin', 'pegawai')`);
        await queryRunner.query(`ALTER TABLE "users" ADD "role" "public"."users_role_enum" NOT NULL DEFAULT 'pegawai'`);
    }

    public async down(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "users" DROP COLUMN "role"`);
        await queryRunner.query(`DROP TYPE "public"."users_role_enum"`);
        await queryRunner.query(`ALTER TABLE "users" ADD "role" character varying NOT NULL DEFAULT 'pegawai'`);
        await queryRunner.query(`ALTER TABLE "barang" DROP COLUMN "kategori"`);
        await queryRunner.query(`ALTER TABLE "permintaan" RENAME COLUMN "catatan" TO "catatan_admin"`);
    }

}
