"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermintaanService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const permintaan_entity_1 = require("../entities/permintaan.entity");
const detail_permintaan_entity_1 = require("../entities/detail_permintaan.entity");
const barang_entity_1 = require("../entities/barang.entity");
const user_entity_1 = require("../entities/user.entity");
const typeorm_2 = require("typeorm");
const PdfPrinter = __importStar(require("pdfmake"));
const path = __importStar(require("path"));
let PermintaanService = class PermintaanService {
    permintaanRepo;
    detailRepo;
    barangRepo;
    userRepo;
    dataSource;
    constructor(permintaanRepo, detailRepo, barangRepo, userRepo, dataSource) {
        this.permintaanRepo = permintaanRepo;
        this.detailRepo = detailRepo;
        this.barangRepo = barangRepo;
        this.userRepo = userRepo;
        this.dataSource = dataSource;
    }
    async create(dto, userId) {
        if (!dto.items || dto.items.length === 0) {
            throw new common_1.BadRequestException('Items tidak boleh kosong');
        }
        const barangIds = dto.items.map((item) => item.id_barang);
        const barangList = await this.barangRepo.findByIds(barangIds);
        if (!barangList || barangList.length !== barangIds.length) {
            throw new common_1.BadRequestException('Ada barang yang tidak ditemukan atau tidak aktif');
        }
        for (const item of dto.items) {
            const barang = barangList.find((b) => b.id === item.id_barang);
            if (!barang) {
                throw new common_1.BadRequestException(`Barang dengan ID ${item.id_barang} tidak ditemukan`);
            }
            if (!barang.status_aktif) {
                throw new common_1.BadRequestException(`Barang dengan ID ${item.id_barang} tidak aktif`);
            }
            if (barang.stok < item.jumlah) {
                throw new common_1.BadRequestException(`Stok barang "${barang.nama_barang}" tidak mencukupi. Stok tersedia: ${barang.stok}, diminta: ${item.jumlah}`);
            }
        }
        return await this.dataSource.transaction(async (manager) => {
            const permintaan = this.permintaanRepo.create({
                id_user_pemohon: userId,
                catatan: dto.catatan,
                status: 'Menunggu',
                tanggal_permintaan: new Date(),
            });
            const savedPermintaan = await manager.save(permintaan);
            const details = dto.items.map((item) => this.detailRepo.create({
                id_permintaan: savedPermintaan.id,
                id_barang: item.id_barang,
                jumlah_diminta: item.jumlah,
                jumlah_disetujui: 0,
            }));
            const savedDetails = await manager.save(details);
            return {
                ...savedPermintaan,
                items: savedDetails,
            };
        });
    }
    async getRiwayatByUser(userId) {
        const riwayat = await this.permintaanRepo.find({
            where: { id_user_pemohon: userId },
            order: { tanggal_permintaan: 'DESC' },
            relations: ['details', 'details.barang'],
        });
        return riwayat.map((permintaan) => ({
            ...permintaan,
            items: permintaan.details,
        }));
    }
    async findOneById(id) {
        const permintaan = await this.permintaanRepo.findOne({
            where: { id },
            relations: ['details', 'details.barang', 'pemohon'],
        });
        if (!permintaan)
            throw new common_1.NotFoundException('Permintaan tidak ditemukan');
        return {
            ...permintaan,
            items: permintaan.details,
        };
    }
    async getPermintaanMenunggu() {
        return this.permintaanRepo.find({
            where: { status: 'Menunggu' },
            order: { tanggal_permintaan: 'ASC' },
            relations: ['details', 'details.barang', 'pemohon'],
        });
    }
    async verifikasiPermintaan(id, dto, verifikatorId) {
        return this.dataSource.transaction(async (manager) => {
            const permintaan = await manager.findOne(permintaan_entity_1.Permintaan, {
                where: { id },
                relations: ['details', 'details.barang'],
            });
            if (!permintaan)
                throw new common_1.NotFoundException('Permintaan tidak ditemukan');
            if (permintaan.status !== 'Menunggu')
                throw new common_1.BadRequestException('Permintaan sudah diverifikasi');
            const allowedKeputusan = ['setuju', 'sebagian', 'tolak'];
            if (!allowedKeputusan.includes(dto.keputusan)) {
                throw new common_1.BadRequestException('Keputusan tidak valid');
            }
            for (const item of dto.items) {
                const detail = permintaan.details.find((d) => d.id === item.id_detail);
                if (!detail)
                    throw new common_1.BadRequestException(`Detail permintaan tidak ditemukan`);
                if (item.jumlah_disetujui > detail.barang.stok) {
                    throw new common_1.BadRequestException(`Stok barang "${detail.barang.nama_barang}" tidak mencukupi. Stok tersedia: ${detail.barang.stok}, diminta: ${item.jumlah_disetujui}`);
                }
                if (item.jumlah_disetujui > detail.jumlah_diminta) {
                    throw new common_1.BadRequestException(`Jumlah disetujui tidak boleh melebihi jumlah diminta`);
                }
                detail.jumlah_disetujui = item.jumlah_disetujui;
            }
            if (dto.keputusan !== 'tolak') {
                for (const item of dto.items) {
                    const detail = permintaan.details.find((d) => d.id === item.id_detail);
                    if (!detail)
                        throw new common_1.BadRequestException(`Detail permintaan tidak ditemukan`);
                    if (item.jumlah_disetujui > 0) {
                        detail.barang.stok -= item.jumlah_disetujui;
                        if (detail.barang.stok < 0) {
                            throw new common_1.BadRequestException(`Stok barang "${detail.barang.nama_barang}" tidak boleh minus`);
                        }
                        await manager.save(detail.barang);
                    }
                }
            }
            let status = 'Ditolak';
            if (dto.keputusan === 'setuju')
                status = 'Disetujui';
            else if (dto.keputusan === 'sebagian')
                status = 'Disetujui Sebagian';
            permintaan.status = status;
            permintaan.id_user_verifikator = verifikatorId;
            permintaan.tanggal_verifikasi = new Date();
            permintaan.catatan = dto.catatan_verifikasi ?? '';
            await manager.save(permintaan.details);
            await manager.save(permintaan);
            return {
                ...permintaan,
                items: permintaan.details,
            };
        });
    }
    async getDashboardStatistik() {
        const [totalBarang, totalPermintaanTertunda, totalBarangKritis, totalUser] = await Promise.all([
            this.barangRepo.count(),
            this.permintaanRepo.count({ where: { status: 'Menunggu' } }),
            this.barangRepo
                .createQueryBuilder('barang')
                .where('barang.stok <= barang.ambang_batas_kritis')
                .andWhere('barang.status_aktif = :aktif', { aktif: true })
                .getCount(),
            this.userRepo.count({ where: { status_aktif: true } }),
        ]);
        return {
            totalBarang,
            totalPermintaanTertunda,
            totalBarangKritis,
            totalUser,
        };
    }
    async getTrenPermintaanBulanan() {
        const now = new Date();
        const start = new Date(now.getFullYear(), now.getMonth() - 11, 1);
        const data = await this.permintaanRepo
            .createQueryBuilder('permintaan')
            .select([
            "TO_CHAR(permintaan.tanggal_permintaan, 'YYYY-MM') AS bulan",
            'COUNT(*)::int AS jumlah',
        ])
            .where('permintaan.tanggal_permintaan >= :start', { start })
            .groupBy('bulan')
            .orderBy('bulan', 'ASC')
            .getRawMany();
        const result = [];
        for (let i = 0; i < 12; i++) {
            const d = new Date(now.getFullYear(), now.getMonth() - 11 + i, 1);
            const bulan = d.toISOString().slice(0, 7);
            const found = data.find((row) => row.bulan === bulan);
            result.push({ bulan, jumlah: found ? Number(found.jumlah) : 0 });
        }
        return result;
    }
    async generateBuktiPermintaanPDF(id) {
        const permintaan = await this.findOneById(id);
        const formatDate = (date) => {
            if (!date)
                return '-';
            const namaBulan = [
                'Januari',
                'Februari',
                'Maret',
                'April',
                'Mei',
                'Juni',
                'Juli',
                'Agustus',
                'September',
                'Oktober',
                'November',
                'Desember',
            ];
            const day = String(date.getDate()).padStart(2, '0');
            const month = date.getMonth();
            const year = date.getFullYear();
            return `${day} ${namaBulan[month]} ${year}`;
        };
        const today = new Date();
        const currentDateString = formatDate(today);
        const permintaanDateString = formatDate(permintaan.tanggal_permintaan);
        const fonts = {
            Roboto: {
                normal: path.join(__dirname, '../assets/fonts/Roboto-Regular.ttf'),
                bold: path.join(__dirname, '../assets/fonts/Roboto-Bold.ttf'),
                italics: path.join(__dirname, '../assets/fonts/Roboto-Italic.ttf'),
                bolditalics: path.join(__dirname, '../assets/fonts/Roboto-BoldItalic.ttf'),
            },
        };
        const printer = new PdfPrinter(fonts);
        const logoPath = path.join(__dirname, '../assets/images/logo-bps-pringsewu.png');
        const docDefinition = {
            pageSize: 'A4',
            pageMargins: [40, 60, 40, 60],
            content: [
                {
                    columns: [
                        { width: 170, image: logoPath, fit: [170, 85] },
                        { width: '*', text: '' },
                    ],
                },
                {
                    text: 'Permintaan',
                    style: 'header',
                    alignment: 'center',
                    margin: [0, 10, 0, 0],
                },
                {
                    text: 'Barang Persediaan',
                    style: 'header',
                    alignment: 'center',
                    margin: [0, 0, 0, 15],
                },
                {
                    text: permintaan.pemohon?.unit_kerja ?? '-',
                    style: 'unitKerja',
                    margin: [0, 0, 0, 20],
                },
                {
                    columns: [
                        {
                            width: '50%',
                            text: [
                                { text: 'Nomor Permintaan: ', style: 'labelInfo' },
                                { text: `#${permintaan.id}`, style: 'valueInfo' },
                            ],
                        },
                        {
                            width: '50%',
                            text: [
                                { text: 'Tanggal Permintaan: ', style: 'labelInfo' },
                                { text: permintaanDateString, style: 'valueInfo' },
                            ],
                            alignment: 'right',
                        },
                    ],
                    margin: [0, 0, 0, 10],
                },
                {
                    table: {
                        headerRows: 1,
                        widths: [30, '*', 60, 70, 80, 60],
                        body: [
                            [
                                { text: 'No', style: 'tableHeader' },
                                { text: 'Nama Barang', style: 'tableHeader' },
                                { text: 'Jumlah', style: 'tableHeader' },
                                { text: 'Kode Barang', style: 'tableHeader' },
                                { text: 'Keterangan', style: 'tableHeader' },
                                { text: 'Satuan', style: 'tableHeader' },
                            ],
                            ...permintaan.items.map((item, index) => [
                                { text: index + 1, alignment: 'center' },
                                item.barang?.nama_barang ?? '-',
                                { text: item.jumlah_diminta, alignment: 'center' },
                                { text: item.barang?.kode_barang ?? '-', alignment: 'center' },
                                permintaan.catatan || '-',
                                { text: item.barang?.satuan ?? '-', alignment: 'center' },
                            ]),
                        ],
                    },
                    layout: {
                        hLineWidth: (i, node) => i === 0 || i === 1 || i === node.table.body.length ? 1 : 0.5,
                        vLineWidth: () => 0.5,
                        hLineColor: (i, node) => i === 0 || i === 1 || i === node.table.body.length
                            ? '#aaaaaa'
                            : '#dddddd',
                        vLineColor: () => '#aaaaaa',
                        paddingLeft: () => 8,
                        paddingRight: () => 8,
                        paddingTop: () => 8,
                        paddingBottom: () => 8,
                    },
                },
                {
                    columns: [
                        {
                            width: '50%',
                            stack: [
                                {
                                    text: `\n\n\n`,
                                    margin: [0, 20, 0, 15],
                                },
                                { text: 'Kasubag Umum', margin: [0, 0, 0, 40] },
                                { text: 'Ambriyanto, S.E.', fontSize: 12 },
                            ],
                            alignment: 'left',
                        },
                        {
                            width: '50%',
                            stack: [
                                {
                                    text: `\n\nPringsewu, ${currentDateString}`,
                                    margin: [0, 20, 0, 15],
                                },
                                { text: 'Penerima,', margin: [0, 0, 0, 40] },
                                { text: permintaan.pemohon?.nama ?? '-', fontSize: 12 },
                            ],
                            alignment: 'left',
                        },
                    ],
                },
            ],
            styles: {
                header: { fontSize: 16, bold: true, color: '#000000' },
                unitKerja: { fontSize: 12, bold: true, color: '#000000' },
                tableHeader: {
                    bold: true,
                    fontSize: 10,
                    fillColor: '#f1f5f9',
                    color: '#000000',
                    alignment: 'center',
                    margin: [0, 4],
                },
                labelInfo: { fontSize: 10, color: '#000000' },
                valueInfo: { fontSize: 10, bold: true, color: '#000000' },
            },
            footer: {
                columns: [
                    {
                        text: 'SIAP BPS Pringsewu',
                        alignment: 'center',
                        fontSize: 8,
                        color: '#000000',
                        margin: [0, 10, 0, 0],
                    },
                ],
            },
        };
        const pdfDoc = printer.createPdfKitDocument(docDefinition);
        const chunks = [];
        return new Promise((resolve, reject) => {
            pdfDoc.on('data', (chunk) => chunks.push(chunk));
            pdfDoc.on('end', () => resolve(Buffer.concat(chunks)));
            pdfDoc.on('error', reject);
            pdfDoc.end();
        });
    }
    async getAllPermintaan({ status, page = 1, limit = 20, }) {
        const qb = this.permintaanRepo
            .createQueryBuilder('permintaan')
            .leftJoinAndSelect('permintaan.details', 'details')
            .leftJoinAndSelect('details.barang', 'barang')
            .leftJoinAndSelect('permintaan.pemohon', 'pemohon')
            .orderBy('permintaan.tanggal_permintaan', 'DESC');
        if (status) {
            qb.andWhere('permintaan.status = :status', { status });
        }
        qb.skip((page - 1) * limit).take(limit);
        const [data, total] = await qb.getManyAndCount();
        return { data, total, page, limit };
    }
};
exports.PermintaanService = PermintaanService;
exports.PermintaanService = PermintaanService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(permintaan_entity_1.Permintaan)),
    __param(1, (0, typeorm_1.InjectRepository)(detail_permintaan_entity_1.DetailPermintaan)),
    __param(2, (0, typeorm_1.InjectRepository)(barang_entity_1.Barang)),
    __param(3, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.DataSource])
], PermintaanService);
//# sourceMappingURL=permintaan.service.js.map