"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermintaanController = void 0;
const common_1 = require("@nestjs/common");
const permintaan_service_1 = require("./permintaan.service");
const create_permintaan_dto_1 = require("./dto/create-permintaan.dto");
const verifikasi_permintaan_dto_1 = require("./dto/verifikasi-permintaan.dto");
const jwt_auth_guard_1 = require("../auth/jwt-auth.guard");
const roles_decorator_1 = require("../auth/roles.decorator");
let PermintaanController = class PermintaanController {
    permintaanService;
    constructor(permintaanService) {
        this.permintaanService = permintaanService;
    }
    async create(dto, req) {
        return this.permintaanService.create(dto, req.user.userId);
    }
    async getRiwayat(req) {
        return this.permintaanService.getRiwayatByUser(req.user.userId);
    }
    async getPermintaanMasuk(req) {
        if (req.user.role !== 'admin') {
            throw new common_1.ForbiddenException('Hanya admin yang dapat mengakses');
        }
        return this.permintaanService.getPermintaanMenunggu();
    }
    async verifikasi(id, dto, req) {
        return this.permintaanService.verifikasiPermintaan(id, dto, req.user.userId);
    }
    async getDashboardStatistik() {
        return this.permintaanService.getDashboardStatistik();
    }
    async getTrenPermintaanBulanan() {
        return this.permintaanService.getTrenPermintaanBulanan();
    }
    async generateBuktiPermintaanPDF(id, res, req) {
        const permintaan = await this.permintaanService.findOneById(id);
        if (req.user.role !== 'admin' &&
            permintaan.id_user_pemohon !== req.user.userId) {
            throw new common_1.ForbiddenException('Anda tidak berhak mengakses bukti permintaan ini');
        }
        const pdfBuffer = await this.permintaanService.generateBuktiPermintaanPDF(id);
        const today = new Date();
        const dateStr = `${today.getDate()}-${today.getMonth() + 1}-${today.getFullYear()}`;
        res.set({
            'Content-Type': 'application/pdf',
            'Content-Disposition': `attachment; filename="bukti_permintaan_${id}_${dateStr}.pdf"`,
        });
        res.end(pdfBuffer);
    }
    async getAllPermintaan(status, page = 1, limit = 20) {
        return this.permintaanService.getAllPermintaan({ status, page, limit });
    }
    async findOne(req, id) {
        const idNum = Number(id);
        if (!idNum || isNaN(idNum)) {
            throw new common_1.BadRequestException('ID permintaan tidak valid');
        }
        const permintaan = await this.permintaanService.findOneById(idNum);
        if (req.user.role === 'pegawai' &&
            permintaan.id_user_pemohon !== req.user.userId) {
            throw new common_1.ForbiddenException('Akses ditolak');
        }
        return permintaan;
    }
};
exports.PermintaanController = PermintaanController;
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, roles_decorator_1.Roles)('pegawai'),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_permintaan_dto_1.CreatePermintaanDto, Object]),
    __metadata("design:returntype", Promise)
], PermintaanController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, roles_decorator_1.Roles)('pegawai'),
    (0, common_1.Get)('riwayat'),
    __param(0, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PermintaanController.prototype, "getRiwayat", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Get)('masuk'),
    __param(0, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PermintaanController.prototype, "getPermintaanMasuk", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Patch)(':id/verifikasi'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, verifikasi_permintaan_dto_1.VerifikasiPermintaanDto, Object]),
    __metadata("design:returntype", Promise)
], PermintaanController.prototype, "verifikasi", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Get)('dashboard/statistik'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PermintaanController.prototype, "getDashboardStatistik", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Get)('dashboard/tren-permintaan'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PermintaanController.prototype, "getTrenPermintaanBulanan", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)(':id/pdf'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object, Object]),
    __metadata("design:returntype", Promise)
], PermintaanController.prototype, "generateBuktiPermintaanPDF", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, roles_decorator_1.Roles)('admin'),
    (0, common_1.Get)('all'),
    __param(0, (0, common_1.Query)('status')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], PermintaanController.prototype, "getAllPermintaan", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], PermintaanController.prototype, "findOne", null);
exports.PermintaanController = PermintaanController = __decorate([
    (0, common_1.Controller)('permintaan'),
    __metadata("design:paramtypes", [permintaan_service_1.PermintaanService])
], PermintaanController);
//# sourceMappingURL=permintaan.controller.js.map