import { PermintaanService } from './permintaan.service';
import { CreatePermintaanDto } from './dto/create-permintaan.dto';
import { VerifikasiPermintaanDto } from './dto/verifikasi-permintaan.dto';
import { Response } from 'express';
export declare class PermintaanController {
    private readonly permintaanService;
    constructor(permintaanService: PermintaanService);
    create(dto: CreatePermintaanDto, req: any): Promise<{
        items: import("../entities/detail_permintaan.entity").DetailPermintaan[];
        id: number;
        id_user_pemohon: number;
        pemohon: import("../entities/user.entity").User;
        tanggal_permintaan: Date;
        status: "Menunggu" | "Disetujui" | "Disetujui Sebagian" | "Ditolak";
        catatan?: string;
        id_user_verifikator?: number;
        tanggal_verifikasi?: Date;
        created_at: Date;
        updated_at: Date;
        details: import("../entities/detail_permintaan.entity").DetailPermintaan[];
    }>;
    getRiwayat(req: any): Promise<{
        items: import("../entities/detail_permintaan.entity").DetailPermintaan[];
        id: number;
        id_user_pemohon: number;
        pemohon: import("../entities/user.entity").User;
        tanggal_permintaan: Date;
        status: "Menunggu" | "Disetujui" | "Disetujui Sebagian" | "Ditolak";
        catatan?: string;
        id_user_verifikator?: number;
        tanggal_verifikasi?: Date;
        created_at: Date;
        updated_at: Date;
        details: import("../entities/detail_permintaan.entity").DetailPermintaan[];
    }[]>;
    getPermintaanMasuk(req: any): Promise<import("../entities/permintaan.entity").Permintaan[]>;
    verifikasi(id: number, dto: VerifikasiPermintaanDto, req: any): Promise<{
        items: import("../entities/detail_permintaan.entity").DetailPermintaan[];
        id: number;
        id_user_pemohon: number;
        pemohon: import("../entities/user.entity").User;
        tanggal_permintaan: Date;
        status: "Menunggu" | "Disetujui" | "Disetujui Sebagian" | "Ditolak";
        catatan?: string;
        id_user_verifikator?: number;
        tanggal_verifikasi?: Date;
        created_at: Date;
        updated_at: Date;
        details: import("../entities/detail_permintaan.entity").DetailPermintaan[];
    }>;
    getDashboardStatistik(): Promise<{
        totalBarang: number;
        totalPermintaanTertunda: number;
        totalBarangKritis: number;
        totalUser: number;
    }>;
    getTrenPermintaanBulanan(): Promise<{
        bulan: string;
        jumlah: number;
    }[]>;
    generateBuktiPermintaanPDF(id: number, res: Response, req: any): Promise<void>;
    getAllPermintaan(status?: string, page?: number, limit?: number): Promise<{
        data: import("../entities/permintaan.entity").Permintaan[];
        total: number;
        page: number;
        limit: number;
    }>;
    findOne(req: any, id: string): Promise<{
        items: import("../entities/detail_permintaan.entity").DetailPermintaan[];
        id: number;
        id_user_pemohon: number;
        pemohon: import("../entities/user.entity").User;
        tanggal_permintaan: Date;
        status: "Menunggu" | "Disetujui" | "Disetujui Sebagian" | "Ditolak";
        catatan?: string;
        id_user_verifikator?: number;
        tanggal_verifikasi?: Date;
        created_at: Date;
        updated_at: Date;
        details: import("../entities/detail_permintaan.entity").DetailPermintaan[];
    }>;
}
