import { Barang } from '../entities/barang.entity';
import { Repository, DataSource } from 'typeorm';
import { CreateBarangDto } from './dto/create-barang.dto';
import { UpdateBarangDto } from './dto/update-barang.dto';
import { AddStokDto } from './dto/add-stok.dto';
export declare class BarangService {
    private barangRepo;
    private dataSource;
    constructor(barangRepo: Repository<Barang>, dataSource: DataSource);
    create(dto: CreateBarangDto): Promise<Barang>;
    findAll(query?: {
        q?: string;
        status_aktif?: boolean;
        stok_kritis?: boolean;
    }): Promise<Barang[]>;
    findOne(id: number): Promise<Barang>;
    update(id: number, dto: UpdateBarangDto): Promise<Barang>;
    softDelete(id: number): Promise<Barang>;
    remove(id: number): Promise<void>;
    addStok(id: number, dto: AddStokDto): Promise<Barang>;
    getStokKritis(): Promise<Barang[]>;
    getBarangKritis(): Promise<Barang[]>;
    generateLaporanPenggunaanPDF(start: string, end: string, unitKerja?: string): Promise<Buffer>;
    getLaporanPenggunaanJSON(start: string, end: string, unitKerja?: string): Promise<any[]>;
}
